<?php
/**
 * Change number or products per row to 3
 */
add_filter( 'loop_shop_columns', 'loop_columns', 999 );
if ( !function_exists('loop_columns' ) ) {
	function loop_columns() {
		return 3; // 3 products per row
	}
}

/**
 * Change number of related products output
 */
function woo_related_products_limit() {
  global $product;

	$args['posts_per_page'] = 3;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'executive_related_products_args', 20 );
  function executive_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 4 related products
	$args['columns'] = 3; // arranged in 2 columns
	return $args;
}

// Remove sidebar on WooCommerce pages
function remove_sidebar_conditional( $array ) {

	// Hide sidebar on product pages by returning false
	if ( is_woocommerce() || is_cart() || is_checkout() )
		return false;

	// Otherwise, return the original array parameter to keep the sidebar
	return $array;
}
add_filter( 'is_active_sidebar', 'remove_sidebar_conditional', 10, 2 );
